/*=============================================================================
 The most simple application with RichView Package - "Hello World!"
 There are two components on the form:
 TRichView* RichView1  - component for displaying text
 TRVStyle* RVStyle1    - components for customizing appearance of RichView;
 RichView1->Style is set to RVStyle1;
 See more comments in TForm1::FormCreate
{=============================================================================*/
#include <vcl\vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{

}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  // This line adds one line of text in RichView.
  RichView1->AddNL("Hello World!", 0, 0);
  // But text will not be displayed yet.
  // You need to call Format method after adding
  // all contents to RichView:
  RichView1->Format();

  // More about AddNL method:
    // The first parameter of method ("Hello World!") is a text to display
    // The second parameter defines text attributes of added text;
    //  It is an index in the collection of text styles (RVStyle1->TextStyles)
    //  You can customize collection of styles using Object Inspector
    //  (for Delphi 3+, CB 3+)
    // Third parameter defines paragraph attributes of added text;
    //  It is an index in the collection of paragraph styles (RVStyle1->ParaStyles)
  // AddNL is one of methods for adding contents to RichView (Add*** methods)
  // See "Building RichView Document" topic of help file.
  // These methods append items to RichView. But component is not prepared for
  // displaying data until Format method is called.
}
//--------------------------------------------------------------------------- 
